/*****************************************************************************
*  LPC15xx SCT demo
*
*  Use SCT2 as unified timer to generate an interrupt every 10 msec
*  LPC13A4x - SCT0/1 support: – 8 inputs
*                             – 10 outputs
*                             – 16 match/capture registers
*                             – 16 events
*                             – 16 states
*             SCT2/3 support: – 3 inputs
*                             – 6 outputs
*                             – 8 match/capture registers
*                             – 10 events
*                             – 10 states
*****************************************************************************/
#include "LPC15xx.h"

void SCT2_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= EN1_SCT2;                // enable the SCT2 clock

    LPC_SCT2->CONFIG            = (1 << 0) | (1 << 17);    // unified 32-bit timer, auto limit

    LPC_SCT2->MATCH[0].U        = SystemCoreClock/100 - 1; // match 0 @ 100 Hz = 10 msec
    LPC_SCT2->MATCHREL[0].U     = SystemCoreClock/100 - 1;

    LPC_SCT2->EVENT[0].STATE    = 0xFFFFFFFF;              // event 0 happens in all states
    LPC_SCT2->EVENT[0].CTRL     = (1 << 12);               // match 0 condition only

    LPC_SCT2->EVEN              = (1 << 0);                // event 0 generates an interrupt
    NVIC_EnableIRQ(SCT2_IRQn);                             // enable SC2 interrupt

    LPC_SCT2->CTRL_U &= ~(1 << 2);                         // start timer
}
